#include "stdafx.h"
#include "Extension.h"
#include "CFFExplorerSDK.h"
#include "resource.h"
#include "Redirect.h"

#define WM_EXITTHREAD		(WM_USER + 300)

HINSTANCE hInstance;

BOOL IsAlreadyPacked(VOID *pPE);
VOID EnableControls(HWND hDlg, BOOL bPack, BOOL bUnpack);

LRESULT CALLBACK DlgProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);

BOOL APIENTRY DllMain(HMODULE hModule, DWORD dwReason, LPVOID lpReserved)
{
	switch (dwReason)
	{
	case DLL_PROCESS_ATTACH:
		{
			hInstance = (HINSTANCE) hModule;
		}

	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}

    return TRUE;
}

UINT nCFFApiMask[] = 
{
	m_eaGetObjectAddress, 
	m_eaGetObjectSize, 
	m_eaObjectChanged, 
	m_eaReplaceObject, 
	m_eaFreeObject, 
	m_eaGetObjectName,
	m_eaSaveObject,

	m_eaIsPE64, 
	m_eaIsRvaValid, 
	m_eaRvaToOffset, 
	m_eaVaToRva, 
	m_eaVaToRva64, 
	m_eaVaToOffset, 
	m_eaVaToOffset64, 
	m_eaOffsetToRva, 
	m_eaSectionFromRva, 
	m_eaEntryPoint, 
	m_eaGetDataDirectory, 
	m_eaAddSectionHeader, 
	m_eaAddSection, 
	m_eaDeleteSectionHeader, 
	m_eaDeleteSection, 
	m_eaAddDataToLastSection, 
	m_eaRebuildImageSize, 
	m_eaRebuildPEHeader, 
	m_eaRealignPE, 
	m_eaRemoveRelocSection, 
	m_eaBindImports, 
	m_eaRemoveStrongNameSignature, 
	m_eaSetImageBase, 
	m_eaAfterDumpHeaderFix, 

	NULL
};

typedef struct _CFFAPI
{
	d_eaGetObjectAddress eaGetObjectAddress;
	d_eaGetObjectSize eaGetObjectSize;
	d_eaObjectChanged eaObjectChanged;
	d_eaReplaceObject eaReplaceObject;
	d_eaFreeObject eaFreeObject;
	d_eaGetObjectName eaGetObjectName;
	d_eaSaveObject eaSaveObject;

	d_eaIsPE64 eaIsPE64;
	d_eaIsRvaValid eaIsRvaValid;
	d_eaRvaToOffset eaRvaToOffset;
	d_eaVaToRva eaVaToRva;
	d_eaVaToRva64 eaVaToRva64;
	d_eaVaToOffset eaVaToOffset;
	d_eaVaToOffset64 eaVaToOffset64;
	d_eaOffsetToRva eaOffsetToRva;
	d_eaSectionFromRva eaSectionFromRva;
	d_eaEntryPoint eaEntryPoint;
	d_eaGetDataDirectory eaGetDataDirectory;
	d_eaAddSectionHeader eaAddSectionHeader;
	d_eaAddSection eaAddSection;
	d_eaDeleteSectionHeader eaDeleteSectionHeader;
	d_eaDeleteSection eaDeleteSection;
	d_eaAddDataToLastSection eaAddDataToLastSection;
	d_eaRebuildImageSize eaRebuildImageSize;
	d_eaRebuildPEHeader eaRebuildPEHeader;
	d_eaRealignPE eaRealignPE;
	d_eaRemoveRelocSection eaRemoveRelocSection;
	d_eaBindImports eaBindImports;
	d_eaRemoveStrongNameSignature eaRemoveStrongNameSignature;
	d_eaSetImageBase eaSetImageBase;
	d_eaAfterDumpHeaderFix eaAfterDumpHeaderFix;

} CFFAPI, *PCFFAPI;

CFFAPI CFFApi;

extern "C" __declspec(dllexport) BOOL __cdecl ExtensionLoad(EXTINITDATA *pExtInitData)
{
	//
	// Retrieves API Interface
	//

	pExtInitData->RetrieveExtensionApi(nCFFApiMask, &CFFApi);

	//
	// Check that all requested APIs are available
	//

	VOID **ppApi = (VOID **) &CFFApi;

	for (UINT x = 0; ; x++)
	{
		if (nCFFApiMask[x] == 0) break;

		if (ppApi[x] == NULL) return FALSE;
	}

	return TRUE;
}

extern "C" __declspec(dllexport) VOID __cdecl ExtensionUnload()
{
}

//
// If this function is missing, the file name is used as name for the extension
//

extern "C" __declspec(dllexport) WCHAR * __cdecl ExtensionName()
{
	return L"UPX Utility";
}

//
// This function is not necessary
//

extern "C" __declspec(dllexport) WCHAR * __cdecl ExtensionDescription()
{
	return L"A simple GUI for the UPX program.";
}

//
// If this function is missing, it is assumed that the extension
// is always needed/usable
//

extern "C" __declspec(dllexport) BOOL __cdecl ExtensionNeeded(VOID *pObject, UINT uSize)
{
	__try
	{
		if (uSize < sizeof (IMAGE_DOS_HEADER) + sizeof (IMAGE_NT_HEADERS))
			return FALSE;
		//
		// Check if it's a 32bit x86 PE file. If it's not, return FALSE
		//

		IMAGE_DOS_HEADER *pDosHeader = (IMAGE_DOS_HEADER *) pObject;

		if (pDosHeader->e_magic != IMAGE_DOS_SIGNATURE) return FALSE;

		IMAGE_NT_HEADERS *pNtHeaders = (IMAGE_NT_HEADERS *) (pDosHeader->e_lfanew + 
			(ULONG_PTR) pDosHeader);

		if (pNtHeaders->Signature != IMAGE_NT_SIGNATURE) return FALSE;

		if (pNtHeaders->FileHeader.Machine != IMAGE_FILE_MACHINE_I386 ||
			pNtHeaders->OptionalHeader.Magic != IMAGE_NT_OPTIONAL_HDR32_MAGIC)
			return FALSE;

		//
		// Check if it's a .NET executable. If so, UPX can't be used
		//

		if (pNtHeaders->OptionalHeader.NumberOfRvaAndSizes < (IMAGE_DIRECTORY_ENTRY_COM_DESCRIPTOR + 2))
			return TRUE;

		IMAGE_DATA_DIRECTORY DataDir;

		CFFApi.eaGetDataDirectory(pObject, uSize, IMAGE_DIRECTORY_ENTRY_COM_DESCRIPTOR, &DataDir);

		if (DataDir.VirtualAddress != 0 || DataDir.Size != 0) return FALSE;
	}

	__except (EXCEPTION_EXECUTE_HANDLER)
	{
		return FALSE;
	}

	return TRUE;
}

//
// Here is where the extension is executed
//

EXTEVENTSDATA eed;

extern "C" __declspec(dllexport) VOID *  __cdecl ExtensionExecute(LPARAM lParam)
{
	eed.cbSize = sizeof (EXTEVENTSDATA);

	eed.hInstance = hInstance;
	eed.DlgID = DLG_EXTENSION;
	eed.DlgProc = DlgProc;

	return (VOID *) &eed;
}

//
// Here starts the utility code
//

class CConsoleRedir : public CRedirect
{
public:
	HWND hDlg;
	TCHAR TempName[MAX_PATH];
protected:
	void OnChildWrite(UINT OutputID, TCHAR *lpszOutput);
protected:
	virtual void OnChildStarted(TCHAR *lpszCmdLine);
	virtual void OnChildStdOutWrite(TCHAR *lpszBuffer);
	virtual void OnChildStdErrWrite(TCHAR *lpszBuffer);
	virtual void OnChildTerminate();
	virtual void OnChildTerminated();
};

void CConsoleRedir::OnChildStarted(TCHAR *lpszCmdLine)
{
	// useless in this case
}

// Send stdout or stderr text to the display window.

void CConsoleRedir::OnChildWrite(UINT OutputID, TCHAR *lpszOutput)
{
	SendDlgItemMessage(hDlg, ED_RESULT, EM_REPLACESEL, FALSE, (LPARAM) lpszOutput);
}

// Send stdout text to the display window.

void CConsoleRedir::OnChildStdOutWrite(TCHAR *lpszBuffer)
{
	OnChildWrite(0, lpszBuffer);
}

// Send stderr text to the display window.

void CConsoleRedir::OnChildStdErrWrite(TCHAR *lpszBuffer)
{
	OnChildWrite(1, lpszBuffer);
}

// Child process is terminating

void CConsoleRedir::OnChildTerminate()
{
	PostMessage(hDlg, WM_EXITTHREAD, 0, 0);
}

// Child process is terminated correctly.

void CConsoleRedir::OnChildTerminated()
{
	//
	// The temp file has been processed and can now be read
	//

	HANDLE hTempFile = CreateFile(TempName, GENERIC_READ, FILE_SHARE_READ, NULL, 
		OPEN_EXISTING, 0, 0);

	if (hTempFile == INVALID_HANDLE_VALUE) return;

	DWORD FileSize = GetFileSize(hTempFile, NULL);

	if (FileSize == 0) 
	{
		CloseHandle(hTempFile);
		return;
	}

	BYTE *BaseAddress = (BYTE *) VirtualAlloc(NULL, FileSize, 
		MEM_COMMIT, PAGE_READWRITE);

	DWORD BRW;

	if (!ReadFile(hTempFile, BaseAddress, FileSize, &BRW, NULL))
	{
		VirtualFree(BaseAddress, 0, MEM_RELEASE);
		CloseHandle(hTempFile);
		return;
	}

	CloseHandle(hTempFile);

	DeleteFile(TempName);

	//
	// Replace the CFF Object with the processed file
	//

	CFFApi.eaReplaceObject(hDlg, BaseAddress, FileSize);

	VirtualFree(BaseAddress, 0, MEM_RELEASE);

	//
	// Change GUI if necessary
	//

	if (IsDlgButtonChecked(hDlg, CB_CHECKPACK) == BST_CHECKED)
	{
		if (IsAlreadyPacked(CFFApi.eaGetObjectAddress(hDlg)) == TRUE)
			EnableControls(hDlg, FALSE, TRUE);
		else
			EnableControls(hDlg, TRUE, FALSE);
	}
	else
	{
		EnableControls(hDlg, TRUE, TRUE);
	}
}

VOID EnableControls(HWND hDlg, BOOL bPack, BOOL bUnpack)
{
	EnableWindow(GetDlgItem(hDlg, CB_PACKEXPORTS), bPack);
	EnableWindow(GetDlgItem(hDlg, CB_PACKRES), bPack);
	EnableWindow(GetDlgItem(hDlg, CB_ICONS), bPack);
	EnableWindow(GetDlgItem(hDlg, CB_STRIPRELOCS), bPack);
	EnableWindow(GetDlgItem(hDlg, CB_PACKLEVEL), bPack);
	EnableWindow(GetDlgItem(hDlg, CB_FORCE), bPack);
	EnableWindow(GetDlgItem(hDlg, CB_ALLMETHODS), bPack);
	EnableWindow(GetDlgItem(hDlg, CB_EXACT), bPack);
	EnableWindow(GetDlgItem(hDlg, CB_ALLFILTERS), bPack);
	EnableWindow(GetDlgItem(hDlg, IDC_PACK), bPack);

	EnableWindow(GetDlgItem(hDlg, IDC_UNPACK), bUnpack);
}

BOOL IsAlreadyPacked(VOID *pPE)
{
	__try
	{
		IMAGE_DOS_HEADER *pDosHeader = (IMAGE_DOS_HEADER *) pPE;

		if (pDosHeader->e_magic != IMAGE_DOS_SIGNATURE) return FALSE;

		IMAGE_NT_HEADERS *pNtHeaders = (IMAGE_NT_HEADERS *) (pDosHeader->e_lfanew + 
			(ULONG_PTR) pDosHeader);

		if (pNtHeaders->Signature != IMAGE_NT_SIGNATURE) return FALSE;

		if (pNtHeaders->FileHeader.Machine != IMAGE_FILE_MACHINE_I386 ||
			pNtHeaders->OptionalHeader.Magic != IMAGE_NT_OPTIONAL_HDR32_MAGIC)
			return FALSE;

		IMAGE_SECTION_HEADER *pSectionHeader = IMAGE_FIRST_SECTION(pNtHeaders);

		if (memcmp(pSectionHeader->Name, "UPX", 3) != 0) return FALSE;
	}

	__except (EXCEPTION_EXECUTE_HANDLER)
	{
		return FALSE;
	}

	return TRUE;
}

static CConsoleRedir cr;

BOOL RunUpx(HWND hDlg, TCHAR *CmdLine, TCHAR *TempName)
{
	SetDlgItemText(hDlg, ED_RESULT, _T(""));
	SendDlgItemMessage(hDlg, ED_RESULT, EM_SETSEL, 0, 0);

	EnableControls(hDlg, FALSE, FALSE);

	VOID *pObject = CFFApi.eaGetObjectAddress(hDlg);
	UINT ObjSize = CFFApi.eaGetObjectSize(hDlg);

	//
	// Write temp file
	//

	HANDLE hTempFile = CreateFile(TempName, GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ, NULL, 
		CREATE_ALWAYS, 0, 0);

	if (hTempFile == INVALID_HANDLE_VALUE) return FALSE;

	DWORD BRW;

	WriteFile(hTempFile, pObject, ObjSize, &BRW, NULL);

	CloseHandle(hTempFile);


	//
	// Start UPX
	//

	cr.hDlg = hDlg;
	_tcscpy_s(cr.TempName, MAX_PATH, TempName);

	if (cr.StartChildProcess(CmdLine, FALSE) == FALSE)
	{
		DeleteFile(TempName);
		return FALSE;
	}

	//
	// Wait for upx to process the file
	//

	return TRUE;
}

VOID ScreenToClient(HWND hWnd, RECT *rc)
{
	ScreenToClient(hWnd, (LPPOINT) rc);
	ScreenToClient(hWnd, ((LPPOINT) rc) + 1);
	if (((DWORD)GetWindowLong(hWnd, GWL_EXSTYLE)) & WS_EX_LAYOUTRTL)
	{
		LONG temp = rc->left;
		rc->left = rc->right;
		rc->right = temp;
	}
}

LRESULT CALLBACK DlgProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{

#define CMDLINESIZE		2048

	static TCHAR Buffer1[MAX_PATH];
	static TCHAR Buffer2[MAX_PATH];
	static TCHAR Buffer3[MAX_PATH];
	static TCHAR TempName[MAX_PATH];
	static TCHAR CmdLine[CMDLINESIZE];

	switch (uMsg)
	{

	case WM_INITDIALOG:
		{
			CheckDlgButton(hDlg, CB_CHECKPACK, BST_CHECKED);

			CheckDlgButton(hDlg, CB_PACKEXPORTS, BST_CHECKED);

			CheckDlgButton(hDlg, CB_PACKRES, BST_CHECKED);

			SendDlgItemMessage(hDlg, CB_ICONS, CB_ADDSTRING, 0, (LPARAM) _T("Don't compress icons"));
			SendDlgItemMessage(hDlg, CB_ICONS, CB_ADDSTRING, 0, (LPARAM) _T("Compress all icons but first"));
			SendDlgItemMessage(hDlg, CB_ICONS, CB_ADDSTRING, 0, (LPARAM) _T("Compress all icons but first directory"));
			SendDlgItemMessage(hDlg, CB_ICONS, CB_ADDSTRING, 0, (LPARAM) _T("Compress all icons"));
			SendDlgItemMessage(hDlg, CB_ICONS, CB_SETCURSEL, 2, 0);

			CheckDlgButton(hDlg, CB_STRIPRELOCS, BST_CHECKED);

			SendDlgItemMessage(hDlg, CB_PACKLEVEL, CB_ADDSTRING, 0, (LPARAM) _T("Compression Level: 1"));
			SendDlgItemMessage(hDlg, CB_PACKLEVEL, CB_ADDSTRING, 0, (LPARAM) _T("Compression Level: 2"));
			SendDlgItemMessage(hDlg, CB_PACKLEVEL, CB_ADDSTRING, 0, (LPARAM) _T("Compression Level: 3"));
			SendDlgItemMessage(hDlg, CB_PACKLEVEL, CB_ADDSTRING, 0, (LPARAM) _T("Compression Level: 4"));
			SendDlgItemMessage(hDlg, CB_PACKLEVEL, CB_ADDSTRING, 0, (LPARAM) _T("Compression Level: 5"));
			SendDlgItemMessage(hDlg, CB_PACKLEVEL, CB_ADDSTRING, 0, (LPARAM) _T("Compression Level: 6"));
			SendDlgItemMessage(hDlg, CB_PACKLEVEL, CB_ADDSTRING, 0, (LPARAM) _T("Compression Level: 7"));
			SendDlgItemMessage(hDlg, CB_PACKLEVEL, CB_ADDSTRING, 0, (LPARAM) _T("Compression Level: 8"));
			SendDlgItemMessage(hDlg, CB_PACKLEVEL, CB_ADDSTRING, 0, (LPARAM) _T("Compression Level: 9"));
			SendDlgItemMessage(hDlg, CB_PACKLEVEL, CB_ADDSTRING, 0, (LPARAM) _T("Compression Level: Best"));
			SendDlgItemMessage(hDlg, CB_PACKLEVEL, CB_ADDSTRING, 0, (LPARAM) _T("Compression Level: Brute"));
			SendDlgItemMessage(hDlg, CB_PACKLEVEL, CB_ADDSTRING, 0, (LPARAM) _T("Compression Level: Ultra-Brute"));
			SendDlgItemMessage(hDlg, CB_PACKLEVEL, CB_SETCURSEL, 6, 0);


			if (IsAlreadyPacked(CFFApi.eaGetObjectAddress(hDlg)) == TRUE)
				EnableControls(hDlg, FALSE, TRUE);
			else
				EnableControls(hDlg, TRUE, FALSE);

			break;
		}

	case WM_SIZE:
		{
			RECT rcPackButton, rcCheckButton, rcCompLevelBox;

			GetWindowRect(GetDlgItem(hDlg, IDC_PACK), &rcPackButton);
			GetWindowRect(GetDlgItem(hDlg, CB_CHECKPACK), &rcCheckButton);
			GetWindowRect(GetDlgItem(hDlg, CB_PACKLEVEL), &rcCompLevelBox);

			ScreenToClient(hDlg, &rcPackButton);
			ScreenToClient(hDlg, &rcCheckButton);
			ScreenToClient(hDlg, &rcCompLevelBox);

			RECT rc, rcp;

			GetClientRect(hDlg, &rc);

			int WLimit = rc.right < rcCompLevelBox.right + 23 ? rcCompLevelBox.right + 3 :  rc.right - 20;

			MoveWindow(GetDlgItem(hDlg, GB_CHECKPACK), 10, rcCheckButton.top - 17, WLimit, 
				(rcCheckButton.bottom - rcCheckButton.top) + 25, TRUE);

			MoveWindow(GetDlgItem(hDlg, GB_UPX), 10, rcCheckButton.top + 32, WLimit, rc.bottom - ((rcCheckButton.top + 32) + 8), TRUE);

			MoveWindow(GetDlgItem(hDlg, ED_RESULT), 20, rcPackButton.bottom + 10, WLimit - 20, rc.bottom - 
				((rcPackButton.bottom + 10) + 18), TRUE);

			break;
		}

	case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{

			case CB_CHECKPACK:
				{
					if (IsDlgButtonChecked(hDlg, CB_CHECKPACK) == BST_CHECKED)
					{
						if (IsAlreadyPacked(CFFApi.eaGetObjectAddress(hDlg)) == TRUE)
							EnableControls(hDlg, FALSE, TRUE);
						else
							EnableControls(hDlg, TRUE, FALSE);
					}
					else
					{
						EnableControls(hDlg, TRUE, TRUE);
					}

					break;
				}

			case IDC_UNPACK:
				{
					GetModuleFileName((HMODULE) hInstance, Buffer1, MAX_PATH);
					_tsplitpath_s(Buffer1, Buffer2, MAX_PATH, Buffer3, MAX_PATH, NULL, 0, NULL, 0);
					_tcscat_s(Buffer2, MAX_PATH, Buffer3);
					_tcscat_s(Buffer2, MAX_PATH, _T("upx.exe"));
					GetShortPathName(Buffer2, CmdLine, MAX_PATH); // upx.exe

					GetTempPath(MAX_PATH, Buffer1);
					GetTempFileName(Buffer1, _T("upx"), 0, Buffer2); 
					GetShortPathName(Buffer2, TempName, MAX_PATH); // temp file name

					// add file to unpack

					_tcscat_s(CmdLine, CMDLINESIZE, _T(" -d "));
					_tcscat_s(CmdLine, CMDLINESIZE, TempName);

					RunUpx(hDlg, CmdLine, TempName);

					break;
				}
				
			case IDC_PACK:
				{
					GetModuleFileName((HMODULE) hInstance, Buffer1, MAX_PATH);
					_tsplitpath_s(Buffer1, Buffer2, MAX_PATH, Buffer3, MAX_PATH, NULL, 0, NULL, 0);
					_tcscat_s(Buffer2, MAX_PATH, Buffer3);
					_tcscat_s(Buffer2, MAX_PATH, _T("upx.exe"));
					GetShortPathName(Buffer2, CmdLine, MAX_PATH); // upx.exe

					GetTempPath(MAX_PATH, Buffer1);
					GetTempFileName(Buffer1, _T("upx"), 0, Buffer2); 
					GetShortPathName(Buffer2, TempName, MAX_PATH); // temp file name

					TCHAR CompLevel[][30] =
					{
						_T("-1"),            // 0
						_T("-2"),            // 1
						_T("-3"),            // 2
						_T("-4"),            // 3
						_T("-5"),            // 4
						_T("-6"),            // 5
						_T("-7"),            // 6
						_T("-8"),            // 7
						_T("-9"),            // 8
						_T("--best"),        // 9
						_T("--brute"),       // 11
						_T("--ultra-brute")  // 12
					};

					_tcscat_s(CmdLine, CMDLINESIZE, _T(" "));
					int nSelItem = (int) SendDlgItemMessage(hDlg, CB_PACKLEVEL, CB_GETCURSEL, 0, 0);
					_tcscat_s(CmdLine, CMDLINESIZE, CompLevel[nSelItem]);

					// more general

					if (IsDlgButtonChecked(hDlg, CB_FORCE) == BST_CHECKED)
						_tcscat_s(CmdLine, CMDLINESIZE, _T(" --force"));

					if (IsDlgButtonChecked(hDlg, CB_EXACT) == BST_CHECKED)
						_tcscat_s(CmdLine, CMDLINESIZE, _T(" --exact"));

					if (IsDlgButtonChecked(hDlg, CB_ALLMETHODS) == BST_CHECKED)
						_tcscat_s(CmdLine, CMDLINESIZE, _T(" --all-methods"));

					if (IsDlgButtonChecked(hDlg, CB_ALLFILTERS) == BST_CHECKED)
						_tcscat_s(CmdLine, CMDLINESIZE, _T(" --all-filters"));

					// PE related

					if (IsDlgButtonChecked(hDlg, CB_PACKEXPORTS) == BST_CHECKED)
						_tcscat_s(CmdLine, CMDLINESIZE, _T(" --compress-exports=1"));
					else
						_tcscat_s(CmdLine, CMDLINESIZE, _T(" --compress-exports=0"));

					if (IsDlgButtonChecked(hDlg, CB_PACKRES) == BST_CHECKED)
					{
						TCHAR CompIcon[][40] =
						{
							_T("--compress-icons=0"),
							_T("--compress-icons=1"),
							_T("--compress-icons=2"),
							_T("--compress-icons=3"),
						};

						_tcscat_s(CmdLine, CMDLINESIZE, _T(" "));
						nSelItem = (int) SendDlgItemMessage(hDlg, CB_ICONS, CB_GETCURSEL, 0, 0);
						_tcscat_s(CmdLine, CMDLINESIZE, CompIcon[nSelItem]);
					}
					else
					{
						_tcscat_s(CmdLine, CMDLINESIZE, _T(" --compress-resources=0"));
					}

					if (IsDlgButtonChecked(hDlg, CB_STRIPRELOCS) == BST_CHECKED)
						_tcscat_s(CmdLine, CMDLINESIZE, _T(" --strip-relocs=1"));
					else
						_tcscat_s(CmdLine, CMDLINESIZE, _T(" --strip-relocs=0"));

					// add file to pack

					_tcscat_s(CmdLine, CMDLINESIZE, _T(" "));
					_tcscat_s(CmdLine, CMDLINESIZE, TempName);

					RunUpx(hDlg, CmdLine, TempName);

					break;
				}
			}
			break;
		}

	case WM_EXITTHREAD:
		{
			cr.TerminateChildProcess();
			break;
		}
	}

	return FALSE;
}